/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IConfigurableFilter;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.blay09.mods.refinedrelocation.client.gui.GuiNameFilter;
import net.blay09.mods.refinedrelocation.container.ContainerNameFilter;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class NameFilter
implements IFilter,
IConfigurableFilter {
    public static final String ID = "refinedrelocation:name_filter";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("[^*]+|(\\*)");
    private static final Matcher WILDCARD_MATCHER = WILDCARD_PATTERN.matcher("");
    private String value = "";
    private Pattern[] cachedPatterns;
    private boolean[] isOreDict;

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        String itemName = null;
        String[] oreNames = null;
        Pattern[] patterns = this.getPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            if (pattern == null) continue;
            if (this.isOreDict[i]) {
                if (oreNames == null) {
                    int[] oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack);
                    oreNames = new String[oreIDs.length];
                    for (int j = 0; j < oreIDs.length; ++j) {
                        oreNames[j] = OreDictionary.getOreName((int)oreIDs[j]);
                    }
                }
                Matcher matcher = pattern.matcher("");
                for (String oreName : oreNames) {
                    matcher.reset(oreName);
                    if (!matcher.matches()) continue;
                    return true;
                }
                continue;
            }
            if (itemName == null) {
                itemName = itemStack.func_82833_r();
            }
            if (!pattern.matcher(itemName).matches()) continue;
            return true;
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
        this.cachedPatterns = null;
    }

    public String getValue() {
        return this.value;
    }

    public Pattern[] getPatterns() {
        if (this.cachedPatterns == null) {
            String[] patternsSplit = this.value.split("[\n,]");
            this.cachedPatterns = new Pattern[patternsSplit.length];
            this.isOreDict = new boolean[patternsSplit.length];
            for (int i = 0; i < patternsSplit.length; ++i) {
                if (patternsSplit[i].startsWith("ore:") && patternsSplit[i].length() > 4) {
                    patternsSplit[i] = patternsSplit[i].substring(4);
                    this.isOreDict[i] = true;
                }
                WILDCARD_MATCHER.reset(patternsSplit[i]);
                StringBuffer sb = new StringBuffer();
                while (WILDCARD_MATCHER.find()) {
                    if (WILDCARD_MATCHER.group(1) != null) {
                        WILDCARD_MATCHER.appendReplacement(sb, ".*");
                        continue;
                    }
                    WILDCARD_MATCHER.appendReplacement(sb, "\\\\Q" + WILDCARD_MATCHER.group(0) + "\\\\E");
                }
                WILDCARD_MATCHER.appendTail(sb);
                try {
                    this.cachedPatterns[i] = Pattern.compile(sb.toString());
                    continue;
                }
                catch (PatternSyntaxException e) {
                    RefinedRelocation.logger.error("Caught an exception in the pattern compilation for the Name Filter. This should never happen, please report: {} => {}", (Object)patternsSplit[i], (Object)sb.toString());
                }
            }
        }
        return this.cachedPatterns;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Patterns", this.value);
        return compound;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.value = compound.func_74779_i("Patterns");
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:name_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:name_filter.description";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFilterIcon getFilterIcon() {
        return ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:icon_name_filter");
    }

    @Override
    public Container createContainer(EntityPlayer player, TileEntity tileEntity) {
        return new ContainerNameFilter(player, tileEntity, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createGuiScreen(EntityPlayer player, TileEntity tileEntity) {
        return new GuiNameFilter(player, tileEntity, this);
    }

    @Override
    public int getVisualOrder() {
        return 900;
    }
}

