/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class PresetFilter
implements IChecklistFilter {
    public static final String ID = "refinedrelocation:preset_filter";
    private static final Map<String, Preset> presetMap = Maps.newHashMap();
    private static final List<Preset> presetList = Lists.newArrayList();
    public static final Preset ORES = new Preset("ores"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            for (String oreName : oreNames) {
                if (!oreName.startsWith("ore")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset INGOTS = new Preset("ingots"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            for (String oreName : oreNames) {
                if (!oreName.startsWith("ingot")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset NUGGETS = new Preset("nuggets"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            for (String oreName : oreNames) {
                if (!oreName.startsWith("nugget")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset GEMS = new Preset("gems"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            for (String oreName : oreNames) {
                if (!oreName.startsWith("gem")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset DYES = new Preset("dyes"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            for (String oreName : oreNames) {
                if (!oreName.startsWith("dye")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset FOOD = new Preset("food"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77973_b() instanceof ItemFood;
        }
    };
    public static final Preset FUEL_ITEMS = new Preset("fuel"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
        }
    };
    public static final Preset BLOCKS = new Preset("blocks"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77973_b() instanceof ItemBlock;
        }
    };
    public static final Preset UNSTACKABLE = new Preset("unstackable"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77976_d() <= 1;
        }
    };
    public static final Preset REPAIRABLE = new Preset("repairable"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77973_b().isRepairable();
        }
    };
    public static final Preset WEAPONS = new Preset("weapons"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77973_b() instanceof ItemSword || itemStack.func_77973_b() instanceof ItemBow;
        }
    };
    public static final Preset TOOLS = new Preset("tools"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77973_b() == Items.field_151146_bM || itemStack.func_77973_b() == Items.field_151033_d || itemStack.func_77973_b() instanceof ItemTool || itemStack.func_77973_b() instanceof ItemFishingRod || itemStack.func_77973_b() instanceof ItemShears;
        }
    };
    public static final Preset ENCHANTED = new Preset("enchanted"){

        @Override
        public boolean passes(ItemStack itemStack, String[] oreNames) {
            return itemStack.func_77948_v();
        }
    };
    private final boolean[] presetStates = new boolean[presetList.size()];

    private static void registerPreset(Preset preset) {
        presetMap.put(preset.getId(), preset);
        presetList.add(preset);
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        int i;
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack);
        String[] oreNames = new String[oreIDs.length];
        for (i = 0; i < oreIDs.length; ++i) {
            oreNames[i] = OreDictionary.getOreName((int)oreIDs[i]);
        }
        for (i = 0; i < presetList.size(); ++i) {
            if (!this.presetStates[i] || !presetList.get(i).passes(itemStack, oreNames)) continue;
            return true;
        }
        return false;
    }

    public NBTBase serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.presetStates.length; ++i) {
            if (!this.presetStates[i]) continue;
            list.func_74742_a((NBTBase)new NBTTagString(presetList.get(i).getId()));
        }
        return list;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagList list = (NBTTagList)nbt;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            int index;
            Preset preset = presetMap.get(list.func_150307_f(i));
            if (preset == null || (index = presetList.indexOf(preset)) == -1) continue;
            this.presetStates[index] = true;
        }
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:preset_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:preset_filter.description";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFilterIcon getFilterIcon() {
        return ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:icon_preset_filter");
    }

    @Override
    public String getOptionLangKey(int option) {
        return "filter.refinedrelocation:preset_filter.option_" + presetList.get(option).getId();
    }

    @Override
    public void setOptionChecked(int option, boolean checked) {
        this.presetStates[option] = checked;
    }

    @Override
    public boolean isOptionChecked(int option) {
        return this.presetStates[option];
    }

    @Override
    public int getOptionCount() {
        return presetMap.size();
    }

    @Override
    public int getVisualOrder() {
        return 1000;
    }

    static {
        PresetFilter.registerPreset(BLOCKS);
        PresetFilter.registerPreset(ORES);
        PresetFilter.registerPreset(INGOTS);
        PresetFilter.registerPreset(NUGGETS);
        PresetFilter.registerPreset(GEMS);
        PresetFilter.registerPreset(FOOD);
        PresetFilter.registerPreset(DYES);
        PresetFilter.registerPreset(UNSTACKABLE);
        PresetFilter.registerPreset(FUEL_ITEMS);
        PresetFilter.registerPreset(REPAIRABLE);
        PresetFilter.registerPreset(WEAPONS);
        PresetFilter.registerPreset(TOOLS);
        PresetFilter.registerPreset(ENCHANTED);
        presetList.addAll(presetMap.values());
    }

    public static abstract class Preset {
        private final String id;

        public Preset(String id) {
            this.id = id;
        }

        public final String getId() {
            return this.id;
        }

        public abstract boolean passes(ItemStack var1, String[] var2);
    }
}

