/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.network;

import io.netty.buffer.ByteBuf;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageContainer
implements IMessage,
IContainerMessage {
    public static final int TYPE_INT = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_NBT = 2;
    public static final int TYPE_BYTE_ARRAY = 3;
    public static final int TYPE_INT_TWO = 4;
    private int type;
    private String key;
    private int intValue;
    private int secondaryIntValue;
    private String stringValue;
    private NBTTagCompound nbtValue;
    private byte[] byteArrayValue;

    public MessageContainer() {
    }

    public MessageContainer(String key, int value) {
        this.key = key;
        this.type = 0;
        this.intValue = value;
    }

    public MessageContainer(String key, int value, int value2) {
        this.key = key;
        this.type = 4;
        this.intValue = value;
        this.secondaryIntValue = value2;
    }

    public MessageContainer(String key, String value) {
        this.key = key;
        this.type = 1;
        this.stringValue = value;
    }

    public MessageContainer(String key, NBTTagCompound value) {
        this.key = key;
        this.type = 2;
        this.nbtValue = value;
    }

    public MessageContainer(String key, byte[] value) {
        this.key = key;
        this.type = 3;
        this.byteArrayValue = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
        byte type = buf.readByte();
        if (type == 0) {
            this.intValue = buf.readInt();
        } else if (type == 1) {
            this.stringValue = ByteBufUtils.readUTF8String((ByteBuf)buf);
        } else if (type == 2) {
            this.nbtValue = ByteBufUtils.readTag((ByteBuf)buf);
        } else if (type == 3) {
            this.byteArrayValue = new byte[buf.readShort()];
            buf.readBytes(this.byteArrayValue);
        } else if (type == 4) {
            this.intValue = buf.readInt();
            this.secondaryIntValue = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
        buf.writeByte(this.type);
        if (this.type == 0) {
            buf.writeInt(this.intValue);
        } else if (this.type == 1) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.stringValue);
        } else if (this.type == 2) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbtValue);
        } else if (this.type == 3) {
            buf.writeShort(this.byteArrayValue.length);
            buf.writeBytes(this.byteArrayValue);
        } else if (this.type == 4) {
            buf.writeInt(this.intValue);
            buf.writeInt(this.secondaryIntValue);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getIntValue() {
        return this.intValue;
    }

    @Override
    public int getSecondaryIntValue() {
        return this.secondaryIntValue;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public NBTTagCompound getNBTValue() {
        return this.nbtValue;
    }

    @Override
    public byte[] getByteArrayValue() {
        return this.byteArrayValue;
    }
}

