/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModItems;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.blay09.mods.refinedrelocation.util.ItemUtils;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileBlockExtender
extends TileMod
implements ITickable {
    private final ItemStackHandler itemHandlerUpgrades = new ItemStackHandler(3){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() != ModItems.stackLimiter && stack.func_77973_b() != ModItems.outputFilter && stack.func_77973_b() != ModItems.inputFilter && stack.func_77973_b() != ModItems.slotLock) {
                return stack;
            }
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_77973_b() != stack.func_77973_b()) continue;
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileBlockExtender.this.updateUpgrades();
            TileBlockExtender.this.func_70296_d();
        }
    };
    private final EnumFacing[] sideMappings = new EnumFacing[5];
    private final IRootFilter inputFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);
    private final IRootFilter outputFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);
    private int stackLimiterLimit = 64;
    private boolean hasStackLimiter;
    private boolean hasSlotLock;
    private boolean hasInputFilter;
    private boolean hasOutputFilter;
    private TileEntity cachedConnectedTile;
    private final ItemHandlerWrapper[] cachedItemHandlers = new ItemHandlerWrapper[6];
    private final EnumFacing[] cachedFacingToFacingMappings = new EnumFacing[6];

    @Nullable
    public EnumFacing getSideMapping(RelativeSide side) {
        return this.sideMappings[side.ordinal()];
    }

    public void setSideMapping(RelativeSide side, @Nullable EnumFacing facing) {
        this.sideMappings[side.ordinal()] = facing;
        this.cachedFacingToFacingMappings[side.toFacing((EnumFacing)this.getFacing()).ordinal()] = facing;
        this.func_70296_d();
    }

    public void func_73660_a() {
        this.baseUpdate();
    }

    @Override
    protected void onFirstTick() {
        this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (this.cachedConnectedTile instanceof TileBlockExtender) {
            this.cachedConnectedTile = null;
        }
        for (int i = 0; i < this.sideMappings.length; ++i) {
            this.cachedFacingToFacingMappings[RelativeSide.fromIndex((int)i).toFacing((EnumFacing)this.getFacing()).ordinal()] = this.sideMappings[i];
        }
        this.updateUpgrades();
    }

    @Nullable
    public EnumFacing getSideMapping(@Nullable EnumFacing facing) {
        if (facing == null) {
            return this.getFacing().func_176734_d();
        }
        return this.cachedFacingToFacingMappings[facing.ordinal()];
    }

    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)this.func_145832_p());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        byte[] mappings = new byte[5];
        for (int i = 0; i < this.sideMappings.length; ++i) {
            mappings[i] = (byte)(this.sideMappings[i] == null ? -1 : (byte)this.sideMappings[i].func_176745_a());
        }
        compound.func_74773_a("SideMappings", mappings);
        compound.func_74782_a("Upgrades", (NBTBase)this.itemHandlerUpgrades.serializeNBT());
        compound.func_74774_a("StackLimiter", (byte)this.stackLimiterLimit);
        compound.func_74782_a("InputFilter", this.inputFilter.serializeNBT());
        compound.func_74782_a("OutputFilter", this.outputFilter.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        byte[] mappings = compound.func_74770_j("SideMappings");
        if (mappings.length == 5) {
            for (int i = 0; i < mappings.length; ++i) {
                this.sideMappings[i] = mappings[i] != -1 ? EnumFacing.func_82600_a((int)mappings[i]) : null;
            }
        }
        this.itemHandlerUpgrades.deserializeNBT(compound.func_74775_l("Upgrades"));
        this.stackLimiterLimit = compound.func_74771_c("StackLimiter");
        this.inputFilter.deserializeNBT((NBTBase)compound.func_74775_l("InputFilter"));
        this.outputFilter.deserializeNBT((NBTBase)compound.func_74775_l("OutputFilter"));
        this.updateUpgrades();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        EnumFacing ioSide;
        if (this.cachedConnectedTile != null && (ioSide = this.getSideMapping(facing)) != null) {
            return this.cachedConnectedTile.hasCapability(capability, ioSide);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        EnumFacing ioSide;
        if (this.cachedConnectedTile != null && (ioSide = this.getSideMapping(facing)) != null) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.requiresItemHandlerWrapping()) {
                int cacheIdx = ioSide.func_176745_a();
                if (this.cachedItemHandlers[cacheIdx] != null) {
                    if (!this.cachedItemHandlers[cacheIdx].revalidate()) {
                        this.cachedItemHandlers[cacheIdx] = null;
                        return null;
                    }
                } else {
                    IItemHandler itemHandler = (IItemHandler)this.cachedConnectedTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ioSide);
                    if (itemHandler == null) {
                        return null;
                    }
                    this.cachedItemHandlers[cacheIdx] = new ItemHandlerWrapper(this.cachedConnectedTile, ioSide, itemHandler);
                }
                return (T)this.cachedItemHandlers[cacheIdx];
            }
            return (T)this.cachedConnectedTile.getCapability(capability, ioSide);
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean requiresItemHandlerWrapping() {
        return this.hasStackLimiter || this.hasSlotLock || this.hasInputFilter || this.hasOutputFilter;
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:block_extender";
    }

    public ItemStackHandler getItemHandlerUpgrades() {
        return this.itemHandlerUpgrades;
    }

    private void updateUpgrades() {
        this.hasStackLimiter = false;
        this.hasSlotLock = false;
        this.hasInputFilter = false;
        this.hasOutputFilter = false;
        for (int i = 0; i < this.itemHandlerUpgrades.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandlerUpgrades.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == ModItems.stackLimiter) {
                this.hasStackLimiter = true;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.slotLock) {
                this.hasSlotLock = true;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.inputFilter) {
                this.hasInputFilter = true;
                continue;
            }
            if (itemStack.func_77973_b() != ModItems.outputFilter) continue;
            this.hasOutputFilter = true;
        }
    }

    @Override
    public void dropItemHandlers() {
        super.dropItemHandlers();
        ItemUtils.dropItemHandlerItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.itemHandlerUpgrades);
    }

    public int getStackLimiterLimit() {
        return this.stackLimiterLimit;
    }

    public void setStackLimiterLimit(int stackLimiterLimit) {
        this.stackLimiterLimit = stackLimiterLimit;
    }

    public IRootFilter getInputFilter() {
        return this.inputFilter;
    }

    public IRootFilter getOutputFilter() {
        return this.outputFilter;
    }

    public boolean hasInputFilter() {
        return this.hasInputFilter;
    }

    public boolean hasOutputFilter() {
        return this.hasOutputFilter;
    }

    private class ItemHandlerWrapper
    implements IItemHandler {
        private final TileEntity tileEntity;
        private final EnumFacing facing;
        private IItemHandler baseHandler;

        public ItemHandlerWrapper(@Nullable TileEntity tileEntity, EnumFacing facing, IItemHandler baseHandler) {
            this.tileEntity = tileEntity;
            this.facing = facing;
            this.baseHandler = baseHandler;
        }

        public boolean revalidate() {
            IItemHandler itemHandler = (IItemHandler)this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing);
            if (itemHandler == null) {
                return false;
            }
            this.baseHandler = itemHandler;
            return true;
        }

        public int getSlots() {
            return this.baseHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.baseHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileBlockExtender.this.hasSlotLock && (stack.func_190926_b() || this.getStackInSlot(slot).func_190926_b())) {
                return stack;
            }
            if (TileBlockExtender.this.hasInputFilter && (stack.func_190926_b() || !TileBlockExtender.this.inputFilter.passes(this.tileEntity, stack))) {
                return stack;
            }
            if (TileBlockExtender.this.hasStackLimiter) {
                int space = TileBlockExtender.this.stackLimiterLimit - this.getStackInSlot(slot).func_190916_E();
                if (space <= 0) {
                    return stack;
                }
                int amount = Math.min(stack.func_190916_E(), space);
                if (amount < stack.func_190916_E()) {
                    ItemStack insertStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
                    ItemStack restStack = this.baseHandler.insertItem(slot, insertStack, simulate);
                    int initialRest = stack.func_190916_E() - amount;
                    if (initialRest > 0) {
                        ItemStack otherRestStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)initialRest);
                        if (restStack.func_190926_b()) {
                            return otherRestStack;
                        }
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)restStack)) {
                            restStack.func_190917_f(initialRest);
                        } else if (!((TileBlockExtender)TileBlockExtender.this).field_145850_b.field_72995_K) {
                            TileBlockExtender.this.field_145850_b.func_72838_d((Entity)new EntityItem(TileBlockExtender.this.field_145850_b, (double)TileBlockExtender.this.field_174879_c.func_177958_n() + 0.5, (double)TileBlockExtender.this.field_174879_c.func_177956_o() + 0.5, (double)TileBlockExtender.this.field_174879_c.func_177952_p() + 0.5, otherRestStack));
                        }
                    }
                    return restStack;
                }
            }
            return this.baseHandler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileBlockExtender.this.hasOutputFilter && !TileBlockExtender.this.outputFilter.passes(this.tileEntity, this.getStackInSlot(slot))) {
                return ItemStack.field_190927_a;
            }
            return this.baseHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.baseHandler.getSlots();
        }
    }
}

