/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.util;

import net.blay09.mods.refinedrelocation.util.IContainerWithDoor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class DoorAnimator {
    private final TileEntity tileEntity;
    private final int eventNumPlayers;
    private final int eventForcedOpen;
    private float angle;
    private float prevAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private SoundEvent soundEventOpen;
    private SoundEvent soundEventClose;
    private float openRadius = (float)Math.PI;
    private boolean isForcedOpen;

    public DoorAnimator(TileEntity tileEntity, int eventNumPlayers, int eventForcedOpen) {
        this.tileEntity = tileEntity;
        this.eventNumPlayers = eventNumPlayers;
        this.eventForcedOpen = eventForcedOpen;
    }

    public DoorAnimator setSoundEventOpen(SoundEvent soundEventOpen) {
        this.soundEventOpen = soundEventOpen;
        return this;
    }

    public DoorAnimator setSoundEventClose(SoundEvent soundEventClose) {
        this.soundEventClose = soundEventClose;
        return this;
    }

    public DoorAnimator setOpenRadius(float openRadius) {
        this.openRadius = openRadius;
        return this;
    }

    public void update() {
        ++this.ticksSinceSync;
        int x = this.tileEntity.func_174877_v().func_177958_n();
        int y = this.tileEntity.func_174877_v().func_177956_o();
        int z = this.tileEntity.func_174877_v().func_177952_p();
        if (!this.tileEntity.func_145831_w().field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            float range = 5.0f;
            for (EntityPlayer entityplayer : this.tileEntity.func_145831_w().func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)x - range), (double)((float)y - range), (double)((float)z - range), (double)((float)(x + 1) + range), (double)((float)(y + 1) + range), (double)((float)(z + 1) + range)))) {
                if (!(entityplayer.field_71070_bA instanceof IContainerWithDoor) || !((IContainerWithDoor)entityplayer.field_71070_bA).isTileEntity(this.tileEntity)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevAngle = this.angle;
        if ((this.isForcedOpen || this.numPlayersUsing > 0) && this.angle == 0.0f && this.soundEventOpen != null) {
            this.tileEntity.func_145831_w().func_184133_a(null, this.tileEntity.func_174877_v(), this.soundEventOpen, SoundCategory.BLOCKS, 0.5f, this.tileEntity.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        float angleSpeed = 0.1f;
        if ((this.numPlayersUsing == 0 || !this.isForcedOpen) && this.angle > 0.0f || (this.isForcedOpen || this.numPlayersUsing > 0) && this.angle < 1.0f) {
            float angleBefore = this.angle;
            this.angle = this.numPlayersUsing > 0 || this.isForcedOpen ? (this.angle += angleSpeed) : (this.angle -= angleSpeed);
            this.angle = Math.min(this.angle, 1.0f);
            float playCloseSound = 0.5f;
            if (this.angle < playCloseSound && angleBefore >= playCloseSound && this.soundEventClose != null) {
                this.tileEntity.func_145831_w().func_184133_a(null, this.tileEntity.func_174877_v(), this.soundEventClose, SoundCategory.BLOCKS, 0.5f, this.tileEntity.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.angle = Math.max(this.angle, 0.0f);
        }
    }

    public void toggleForcedOpen() {
        this.setForcedOpen(!this.isForcedOpen);
    }

    public boolean isForcedOpen() {
        return this.isForcedOpen;
    }

    public void setForcedOpen(boolean isForcedOpen) {
        this.isForcedOpen = isForcedOpen;
        this.tileEntity.func_145831_w().func_175641_c(this.tileEntity.func_174877_v(), this.tileEntity.func_145838_q(), 2, isForcedOpen ? 1 : 0);
    }

    public boolean receiveClientEvent(int id, int type) {
        if (id == this.eventNumPlayers) {
            this.numPlayersUsing = type;
            return true;
        }
        if (id == this.eventForcedOpen) {
            this.isForcedOpen = type == 1;
            return true;
        }
        return false;
    }

    public void openContainer(EntityPlayer player) {
        if (!player.func_175149_v()) {
            this.numPlayersUsing = Math.max(0, this.numPlayersUsing + 1);
            this.tileEntity.func_145831_w().func_175641_c(this.tileEntity.func_174877_v(), this.tileEntity.func_145838_q(), this.eventNumPlayers, this.numPlayersUsing);
            this.tileEntity.func_145831_w().func_175685_c(this.tileEntity.func_174877_v(), this.tileEntity.func_145838_q(), true);
            this.tileEntity.func_145831_w().func_175685_c(this.tileEntity.func_174877_v().func_177977_b(), this.tileEntity.func_145838_q(), true);
        }
    }

    public void closeContainer(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.tileEntity.func_145831_w().func_175641_c(this.tileEntity.func_174877_v(), this.tileEntity.func_145838_q(), this.eventNumPlayers, this.numPlayersUsing);
            this.tileEntity.func_145831_w().func_175685_c(this.tileEntity.func_174877_v(), this.tileEntity.func_145838_q(), true);
            this.tileEntity.func_145831_w().func_175685_c(this.tileEntity.func_174877_v().func_177977_b(), this.tileEntity.func_145838_q(), true);
        }
    }

    public float getRenderAngle(float partialTicks) {
        float renderAngle = this.prevAngle + (this.angle - this.prevAngle) * partialTicks;
        renderAngle = 1.0f - renderAngle;
        renderAngle = 1.0f - renderAngle * renderAngle * renderAngle;
        return (float)(Math.PI / (double)this.openRadius * (double)renderAngle);
    }

    public int getNumPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void setNumPlayersUsing(int numPlayersUsing) {
        this.numPlayersUsing = numPlayersUsing;
    }
}

